<?php
// mencegah direct access file PHP agar file PHP tidak bisa diakses secara langsung dari browser dan hanya dapat dijalankan ketika di include oleh file lain
// jika file diakses secara langsung
if (basename($_SERVER['PHP_SELF']) === basename(__FILE__)) {
  // alihkan ke halaman error 404
  header('location: 404.html');
}
// jika file di include oleh file lain, tampilkan isi file
else { ?>
  <div class="container-fluid">
    <!-- judul halaman -->
    <h1 class="h4 mb-4 text-gray-800"><i class="fas fa-sign-in-alt fa-fw mr-2"></i>Import</h1>

    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <!-- judul form -->
        <h6 class="m-0 font-weight-bold">Import Data Pengeluaran</h6>
      </div>
      <div class="card-body">
        <!-- form entri data -->
        <form action="modules/pengeluaran/proses_import.php" method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
          
          <div class="form-group col-lg-6 pt-3 pl-0">
            <label>Upload File</label>
            <input type="file" id="excel" name="excel" class="form-control form-control-file" autocomplete="off">
            <!-- <small class="form-text text-secondary">
              Keterangan : <br>
              - Tipe file yang bisa diunggah adalah *.jpg atau *.png. <br>
              - Ukuran file yang bisa diunggah maksimal 1 Mb.
            </small> -->
          </div>

          <hr class="mt-5">

          <div class="form-group pt-3">
            <!-- tombol simpan data -->
            <input type="submit" name="submit" value="Import" class="btn btn-success pl-4 pr-4 mr-2">
            <!-- tombol kembali ke halaman tampil data -->
            <a href="?module=pengeluaran" class="btn btn-secondary pl-4 pr-4">Batal</a>
          </div>
        </form>
      </div>
    </div>
  </div>

<?php } ?>